<?php
// myDBR defaults
// 
// If you want to change the default values, do it in /user/defaults.php as this file will be overridden in updates
// 
$mydbr_defaults = array (
	'chart' => array ('sizeX' => 600,
	                  'sizeY' => 350,
					  'title_color' => 0x00000000, // ImageChart only, ARGB Color 
			      	  'title_font' => 'arialbd.ttf', // ImageChart 
				      'title_font_size' => 10, // ImageChart 
				      'base_font_size' => 10, // Flash Chart 
					  'axis_color' => 0x00000000, // ImageChart only, ARGB Color 
				      'axis_font' => 'arial.ttf', // ImageChart 
				      'axis_font_size' => 8, // ImageChart 
					  'label_color' => 0x00000000, // ImageChart only, ARGB Color 
					  'label_font' => 'arial.ttf', // ImageChart 
					  'label_font_size' => 8, // ImageChart 
					  'legend_default_position' => 'right',
					  'legend_default_style' => array('background_color' => 0xFFFFFFFF, 'edge_color' => 0x888888, 
							'rounded_border' => array('TL' => 5, 'TR' => 5, 'BL' => 5, 'BR' => 5)),
					  'chart_extra_width_with_legend_on_side' => 100,
					  'legend_color' => 0x00000000, // ImageChart only, ARGB Color 
					  'legend_font' => 'arial.ttf', // ImageChart 
					  'legend_font_size' => 8, // ImageChart 
					  'background_color' => 0xFFFFFFFF, // 0x00FFFFFF,
					  'edge_color' => 0xFF000000,
					  'plot_edge_color' => 0xFFFF0001,
					  'raised_effect' => 0,
					  'padding_top' => 0,
					  'grid_color_horizontal' => 0xC0C0C0,
					  'grid_color_vertical' => 0xFF000000,
					  'colors' => array(
							0x0099CC, 
							0xF6BD0F,
							0x8BBA00,
							0xA66EDD,
							0xF984A1,
							0xCCCC00, 
							0x999999, 
							0xAFD8F8,
							0xFF0000, 
							0x006F00,
							0x0099FF, 
							0xFF66CC, 
							0x669966, 
							0x7C7CB4, 
							0xFF9933, 
							0x9900FF, 
							0x99FFCC, 
							0xCCCCFF, 
							0x669900, 
							0x1941A5, 
					   ),
					   'alternate_color' => array('0xFFFFFF', '0xECECEC', '0xc0c0c0', '0xc0c0c0'),
					   'meter' => array(
						'inner' => 0xF4F4F4,
						'outer' => 0x736F6E,
						'outer2' => 0xD5D5D5,
						'pointer' => 0xB82313,
						'green' => 0x6666ff66,
						'yellow' => 0x66ffff33,
						'red' => 0x66ff6666
						),
						
						'softlightning' => true, // For column and bar charts toggles the softlightning effect  
						'always_use_link_menu' => false, // Whether single linked report shows menu or follows link 
						'default_marker' => 16, // GlassSphere2Shape
						'marker_size' => 10, // Marker size for scatter chart
						'autoscale' => array('top'=>0.1, 'bottom'=>0.1, 'zeroaffinity'=>0.5),
						'embed_image' => false,
						'pie_label_format' => '$c->setLabelLayout("SideLayout",-1, 10);$c->setLabelStyle()->setBackground(Transparent, -1, 0);',
						'line_width' => 3,
						'width_per_item' => 110,
						'width_extra' => 80,
						'height_per_item' => 60,
						'height_extra' => 80,
						'gantt' => array(
							'baseline_pattern' => array('color' => 0xe0e0e0, 'border' => 0x808080, 'height' => 8),
							'baseline_text' => 'Baseline',
							'start_of_month_format' => '<*font=arialbd.ttf*>{value|mmm d}',
							'start_of_day_format' => '-{value|d}',
							'start_of_hour_format' => '-{value|hh}',
							'scale' => 7,
							'single_label' => 0
						),
						'skip_null_values' => true,
	),
	'pager' => 20, // Default pager page size in rows 
	'automatic_parameters' => array(
		'username' => 'inLogin', // Automatic report parameter containing the username 
		'ip_address' => 'inIPAddress', // Users IP address
		'locale' => 'inLocale', // locale used in reports
		'user_agent' => 'inUseragent', // locale used in reports
		'autoexecute' => 'inAutoexecute', // Automatically executes the report if parameters are ok
		'accept_language' => 'inHTTP_ACCEPT_LANGUAGE', // HTTP_ACCEPT_LANGUAGE
		'referer' => 'inHTTP_REFERER', // HTTP_REFERER
		),
	'password' => array( 'expiration' => 30, 'length' => 8),
	'autocomplete_max_rows' => 20,
	'header_logo_cell' => 'width: 120px; padding: 1px;',
	'category_colors' => array('00C322','FF7A00','D2006B','0066CC','CC6600', 'A300C3', 'C30061', 'C38500'), // Report category default colors
	'search' => false, // Display search + export by default
	'user_prefs_formatting' => true, // Allow user to have own preferences
	'proxy' => array(), // for optional proxy parameters
	'baselanguage' =>  'en_US',
	'translate_window' =>  array('width' => 500, 'heigth' => 600),
	'db_connection' => array(
		'translate_db_locale' =>  true, // Determines if locale is used in database operations
		'sql_server_init' => 'SET ANSI_WARNINGS ON;SET ANSI_NULLS ON;',
		'sybase_init' => '',
		'sqlanywhere_init' => '',
		'show_verbose_error_messages_to_all_users' => false
	),
	'active_directory_mydbr_groups' => 'myDBR Groups',
	'active_directory_mydbr_admin_group' => 'myDBR Admins',
	'active_directory_sync_users' => array(),
	'active_directory_synconly_users' => array(),
	'active_directory_recursive_user_groups' => true,
	'updater_users' => array('mydbr_updater'), // Usernames which can use HTTP basic access authentication to call myDBR update URL
	'query_builder_widths' => array('db' => 194, 'table' => 194, 'column' => 373, 'selected' => 454),
	'graphviz_dpi' => 96,
	'export' => array(
				'cache_storage' => 'Memory',
				'export_choises' => array('Excel', 'PDF', 'CSV'),
				'colwidth' => 1,
				'excel' => array(
					'type' => 'xlsx', // xls or xlsx as a default output format
					'line_height' => 14,
					'font_width' => 8.3,
					'include_image' => true,
					'utf8_replace' => array()
				),
				'csv' => array(
					'delimiter' => ',',
					'decimal_point' => '.',
					'enclosure' => '"',
					'date_format' => 'Y-m-d', // See http://php.net/manual/en/function.date.php
					'time_format' => 'h:i:s a',
					'charset' => 'utf-8', // utf-8, ISO-8859-1
					'line_ending' => "\n",
					'header' => true, // Output the resultset header?
					'enclose_string_with_leading_or_trailing_space' => true,
					'enclose_always' => false,
					'linefeed_between_resultsets' => true,
					'use_BOM_in_UTF' => true
				),
				'pdf' => array(
					'font' => 'Arial',
					'font_size' => 9,
					'font_width' => 8.5, // Arial 10 default width. Increase this if your PDF output produces columns too narrow
					'column_width_divider' => 5.941,
					'logo' => 'apppic_small.jpg', // in user/images
					'logo_width' => 40,
					'image_scale' => 1.25,
					'export_as_png' => true
					),
				'wkhtmltopdf' => array(
					'command' => 'wkhtmltopdf', 
					'use_as_default' => true,
					'options' => array(
						'margin-top' => '--margin-top 20',
						'header-spacing' => '--header-spacing 8'
					)
					),
				'json' =>  array(
						'force_object' => false
						),
				'sql' => array(
						'is_admin_only' => true
						),
				'xml' => array('compatibility_mode' => false),
				'use_PCLZIP' => false,
				'new_window' => false,
			),
	'favourites_enabled' => true,	
	'mainview' => array('favourites_enabled' => true, 'show_edit' => true, 'show_code' => true, 'show_delete' => true),
	'sql_editor' => array(
			'height' => '500px',
			'replace_tab_by_spaces' => false, // false or number of spaces tab represents
			'use_direct_file'  => true,
			'compress_js' => true,
			'show_query_builder_when_new' => false,	
			'lines_when_to_use_dashes_in_comment' => 4,
			'max_saved' => array('proc' => 10, 'cmd' => 10 ),
	),
	'param_inline_pairs' => array( 'inStartDate' => 'inEndDate', 'dtFrom' => 'dtTo'),
	'notifications' => array( // if missing features are reminded of
		'chartdirector_missing' => 1,
		'chartdirector_not_default' => 1,
		'wkhtml_missing' => 1,
		'new_version_is_for_admin_only' => false
	),
	'error_reporting' => E_ALL & ~E_NOTICE & ~E_STRICT,
	'logout' => array( 'url_redirect' => null, 'url' => 'thankyou.html', 'link_text' => '#{MYDBR_AMAIN_LOGOUT}'),
	'google_maps_api_key' => '',
	'google_maps_business' => array('client_id' => null, 'private_key' => null),
	'cookie_host' => null,
	'stickyheader' => true,
	'datetimefilter' => true,
	'IE_override_compatibility_view' => true,
	'single_sign_on' => array('url_parameter' => 'url', 'allow_admin' => true),
	'remote_server' => array ( 'timeout' => 60, 'skip_ssl_verify' => false ),
	'template' => array ( 'class' => 'template' ),
	'date_time_formats' => array(
			'fi_fi' => array('d' => 'd.m.Y', 't' => 'H.i.s'),
			'de_de' => array('d' => 'd.m.Y', 't' => 'H:i:s'),
			'en_us' => array('d' => 'Y-m-d', 't' => 'h:i:s a'),
			'es_es' => array('d' => 'd/m/Y', 't' => 'H.i.s'),
			'it_it' => array('d' => 'd/m/Y', 't' => 'H.i.s'),
			'nl_nl' => array('d' => 'd-m-Y', 't' => 'H.i.s'),
			'sv_se' => array('d' => 'Y-m-d', 't' => 'H:i:s')
	),
	'connected_parameters' => array( 'show_empty_queries' => false ),
	'login' => array('autocomplete' => 'on', 'use_salted_hash' => true ),
	'tablesorter' => array('default_sorting' => 'intelligent'), /* intelligent/asc/desc */
	'show_main_without_login' => array( 
		'enabled' => false,
		'show_login_link' => false
	),
	'scrollcheckbox' => array( 'lang' => array('de', 'es', 'fi', 'it', 'nl','se') ),
	'admin_restrictions' => array(
		'restricted_actions' => array(),
		'limited_admins' => array(), /* Restrictions apply to these usernames */
		'full_admins' => array() /* No limitations to these usernames */
	),
	'lfcr_post' => array(
		'chr' => array( chr(10), chr(13) ),
		'coded' => array( '#0A', '#0D' ),
		'to' => array( '_ x*_LF_*x_', '_ x*_CR_*x_' )
	)
);
// User's definitions for $mydbr_defaults
require_once( dirname(__FILE__).'/user/defaults.php' );