/* Written by Keith Wood (kbwood{at}iinet.com.au) September 2010.
Licensed under the MIT (https://github.com/jquery/jquery/blob/master/MIT-LICENSE.txt) license.
Please attribute the author if you use it. */
/* http://keith-wood.name/datetimeEntry.html
   Date and time entry for jQuery v1.1.1.
   Written by Keith Wood (kbwood{at}iinet.com.au) September 2010.
   Licensed under the MIT (https://github.com/jquery/jquery/blob/master/MIT-LICENSE.txt) license.
   Please attribute the author if you use it. */

/* Turn an input field into an entry point for a date and/or time value.
   The date/time can be entered via directly typing the value,
   via the arrow keys, or via spinner buttons.
   It is configurable to reorder the fields, to enforce a minimum
   and/or maximum date/time, and to change the spinner image.
   Attach it with $('input selector').datetimeEntry(); for default settings,
   or configure it with options like:
   $('input selector').datetimeEntry(
      {spinnerImage: 'spinnerSquare.png', spinnerSize: [20, 20, 0]}); */

(function($){function DatetimeEntry(){this._disabledInputs=[];this.regional=[];this.regional['']={datetimeFormat:'O/D/Y H:Ma',datetimeSeparators:'.',monthNames:['January','February','March','April','May','June','July','August','September','October','November','December'],monthNamesShort:['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],dayNames:['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'],dayNamesShort:['Sun','Mon','Tue','Wed','Thu','Fri','Sat'],ampmNames:['AM','PM'],spinnerTexts:['Today','Previous field','Next field','Increment','Decrement'],isRTL:false};this._defaults={appendText:'',initialField:-1,useMouseWheel:true,shortYearCutoff:'+10',defaultDatetime:null,minDatetime:null,maxDatetime:null,minTime:null,maxTime:null,timeSteps:[1,1,1],spinnerImage:'spinnerDefault.png',spinnerSize:[20,20,8],spinnerBigImage:'',spinnerBigSize:[40,40,16],spinnerIncDecOnly:false,spinnerRepeat:[500,250],beforeShow:null,altField:null,altFormat:null};$.extend(this._defaults,this.regional['']);}
$.extend(DatetimeEntry.prototype,{markerClassName:'hasDatetimeEntry',propertyName:'datetimeEntry',_appendClass:'datetimeEntry_append',_controlClass:'datetimeEntry_control',_expandClass:'datetimeEntry_expand',setDefaults:function(options){$.extend(this._defaults,options||{});return this;},_attachPlugin:function(target,options){var input=$(target);if(input.hasClass(this.markerClassName)){return;}
var inst={options:$.extend({},this._defaults,options),input:input,_field:0,_selectedYear:0,_selectedMonth:0,_selectedDay:0,_selectedHour:0,_selectedMinute:0,_selectedSecond:0};this._decodeDatetimeFormat(inst);input.data(this.propertyName,inst).addClass(this.markerClassName).bind('focus.'+this.propertyName,this._doFocus).bind('blur.'+this.propertyName,this._doBlur).bind('click.'+this.propertyName,this._doClick).bind('keydown.'+this.propertyName,this._doKeyDown).bind('keypress.'+this.propertyName,this._doKeyPress).bind('paste.'+this.propertyName,function(event){setTimeout(function(){plugin._extractDatetime(inst);},1);});this._optionPlugin(target,options);},_optionPlugin:function(target,options,value){target=$(target);var inst=target.data(this.propertyName);if(!options||(typeof options=='string'&&value==null)){var name=options;options=(inst||{}).options;return(options&&name?options[name]:options);}
if(!target.hasClass(this.markerClassName)){return;}
options=options||{};if(typeof options=='string'){var name=options;options={};options[name]=value;}
var currentDate=this._parseDatetime(inst,target.val());$.extend(inst.options,options);inst._field=0;this._decodeDatetimeFormat(inst);if(currentDate){this._setDatetime(inst,currentDate);}
target.next('span.'+this._appendClass).remove();target.parent().find('span.'+this._controlClass).remove();if($.fn.mousewheel){target.unmousewheel();}
var spinner=(!inst.options.spinnerImage?null:$('<span class="'+this._controlClass+'" style="display: inline-block; '+'background: url(\''+inst.options.spinnerImage+'\') 0 0 no-repeat; width: '+
inst.options.spinnerSize[0]+'px; height: '+inst.options.spinnerSize[1]+'px;"></span>'));target.after(inst.options.appendText?'<span class="'+this._appendClass+'">'+
inst.options.appendText+'</span>':'').after(spinner||'');if(inst.options.useMouseWheel&&$.fn.mousewheel){target.mousewheel(this._doMouseWheel);}
if(spinner){spinner.mousedown(this._handleSpinner).mouseup(this._endSpinner).mouseover(this._expandSpinner).mouseout(this._endSpinner).mousemove(this._describeSpinner);}},_enablePlugin:function(target){this._enableDisable(target,false);},_disablePlugin:function(target){this._enableDisable(target,true);},_enableDisable:function(target,disable){var inst=$.data(target,this.propertyName);if(!inst){return;}
target.disabled=disable;if(target.nextSibling&&target.nextSibling.nodeName.toLowerCase()=='span'){plugin._changeSpinner(inst,target.nextSibling,(disable?5:-1));}
plugin._disabledInputs=$.map(plugin._disabledInputs,function(value){return(value==target?null:value);});if(disable){plugin._disabledInputs.push(target);}},_isDisabledPlugin:function(target){return $.inArray(target,this._disabledInputs)>-1;},_decodeDatetimeFormat:function(inst){inst._fields=[];inst._ampmField=-1;for(var i=0;i<inst.options.datetimeFormat.length;i++){if(inst.options.datetimeFormat.charAt(i).match(/[yYoOnNdDwWhHmMsSaA]/)){inst._fields.push(i);}
if(inst.options.datetimeFormat.charAt(i).toLowerCase()=='a'){inst._ampmField=inst._fields.length-1;}}},_destroyPlugin:function(target){target=$(target);if(!target.hasClass(this.markerClassName)){return;}
target.removeClass(this.markerClassName).removeData(this.propertyName).unbind('.'+this.propertyName);if($.fn.mousewheel){target.unmousewheel();}
this._disabledInputs=$.map(this._disabledInputs,function(value){return(value==target[0]?null:value);});target.siblings('.'+this._appendClass+',.'+this._controlClass).remove();},_setDatetimePlugin:function(target,datetime){var inst=$.data(target,this.propertyName);if(inst){if(datetime===null||datetime===''){inst.input.val('');}
else{this._setDatetime(inst,datetime?(typeof datetime=='object'?new Date(datetime.getTime()):datetime):null);}}},_getDatetimePlugin:function(target){var inst=$.data(target,this.propertyName);return(inst?this._parseDatetime(inst,inst.input.val()):null);},_getOffsetPlugin:function(target){var inst=$.data(target,this.propertyName);var time=(inst?plugin._parseDatetime(inst,inst.input.val()):null);return(!time?0:(time.getHours()*3600+time.getMinutes()*60+time.getSeconds())*1000);},_getField:function(input){var inst=$.data(input,plugin.propertyName),datetimeFormat=inst.options.datetimeFormat,field_return=0,end=0,field,src,offsetX;if(input.selectionStart!=null){for(field=0;field<datetimeFormat.length;field++){end+=plugin._fieldLength(inst,datetimeFormat.charAt(field));if(input.selectionStart<=end){break;}
field_return+=(datetimeFormat.charAt(field).match(/[yondwhmsa]/i)?1:0);}}
else if(input.createTextRange){src=$(event.srcElement);range=input.createTextRange();var convert=function(value){return{thin:2,medium:4,thick:6}[value]||value;};offsetX=event.clientX+document.documentElement.scrollLeft-
(src.offset().left+parseInt(convert(src.css('border-left-width')),10))-
range.offsetLeft;for(field=0;field<datetimeFormat.length;field++){end+=plugin._fieldLength(inst,datetimeFormat.charAt(field));range.collapse();range.moveEnd('character',end);if(offsetX<range.boundingWidth){break;}
field_return+=(datetimeFormat.charAt(field).match(/[yondwhmsa]/i)?1:0);}}
return field_return;},_doFocus:function(target){var input=(target.nodeName&&target.nodeName.toLowerCase()=='input'?target:this);if(plugin._lastInput==input||plugin._isDisabledPlugin(input)){plugin._focussed=false;return;}
var inst=$.data(input,plugin.propertyName);inst._field=plugin._getField(input);plugin._focussed=true;plugin._lastInput=input;plugin._blurredInput=null;$.extend(inst.options,($.isFunction(inst.options.beforeShow)?inst.options.beforeShow.apply(input,[input]):{}));plugin._extractDatetime(inst,false);setTimeout(function(){plugin._showField(inst,true);},10);},_doBlur:function(event){plugin._blurredInput=plugin._lastInput;plugin._lastInput=null;},_doClick:function(event){var input=event.target;var inst=$.data(input,plugin.propertyName);if(!plugin._focussed){var datetimeFormat=inst.options.datetimeFormat;inst._field=0;if(input.selectionStart!=null){var end=0;for(var field=0;field<datetimeFormat.length;field++){end+=plugin._fieldLength(inst,datetimeFormat.charAt(field));if(input.selectionStart<end){break;}
inst._field+=(datetimeFormat.charAt(field).match(/[yondwhmsa]/i)?1:0);}}
else if(input.createTextRange){var src=$(event.srcElement);var range=input.createTextRange();var convert=function(value){return{thin:2,medium:4,thick:6}[value]||value;};var offsetX=event.clientX+document.documentElement.scrollLeft-
(src.offset().left+parseInt(convert(src.css('border-left-width')),10))-
range.offsetLeft;var end=0;for(var field=0;field<datetimeFormat.length;field++){end+=plugin._fieldLength(inst,datetimeFormat.charAt(field));range.collapse();range.moveEnd('character',end);if(offsetX<range.boundingWidth){break;}
inst._field+=(datetimeFormat.charAt(field).match(/[yondwhmsa]/i)?1:0);}}}
plugin._showField(inst);plugin._focussed=false;},_doKeyDown:function(event){if(event.keyCode>=48){return true;}
var inst=$.data(event.target,plugin.propertyName);switch(event.keyCode){case 9:return(event.shiftKey?plugin._changeField(inst,-1,true):plugin._changeField(inst,+1,true));case 35:if(event.ctrlKey){plugin._setValue(inst,'');}
else{inst._field=inst._fields.length-1;plugin._adjustField(inst,0);}
break;case 36:if(event.ctrlKey){plugin._setDatetime(inst);}
else{inst._field=0;plugin._adjustField(inst,0);}
break;case 37:plugin._changeField(inst,-1,false);break;case 38:plugin._adjustField(inst,+1);break;case 39:plugin._changeField(inst,+1,false);break;case 40:plugin._adjustField(inst,-1);break;case 46:plugin._setValue(inst,'');break;default:return true;}
return false;},_doKeyPress:function(event){var chr=String.fromCharCode(event.charCode==undefined?event.keyCode:event.charCode);if(chr<' '){return true;}
var inst=$.data(event.target,plugin.propertyName);plugin._handleKeyPress(inst,chr);return false;},_doMouseWheel:function(event,delta){if(plugin._isDisabledPlugin(event.target)){return;}
var inst=$.data(event.target,plugin.propertyName);inst.input.focus();if(!inst.input.val()){plugin._extractDatetime(inst);}
plugin._adjustField(inst,delta);event.preventDefault();},_expandSpinner:function(event){var spinner=plugin._getSpinnerTarget(event);var inst=$.data(plugin._getInput(spinner),plugin.propertyName);if(plugin._isDisabledPlugin(inst.input[0])){return;}
if(inst.options.spinnerBigImage){inst._expanded=true;var offset=$(spinner).offset();var relative=null;$(spinner).parents().each(function(){var parent=$(this);if(parent.css('position')=='relative'||parent.css('position')=='absolute'){relative=parent.offset();}
return!relative;});$('<div class="'+plugin._expandClass+'" style="position: absolute; left: '+
(offset.left-(inst.options.spinnerBigSize[0]-inst.options.spinnerSize[0])/2-
(relative?relative.left:0))+'px; top: '+
(offset.top-(inst.options.spinnerBigSize[1]-inst.options.spinnerSize[1])/2-
(relative?relative.top:0))+'px; width: '+
inst.options.spinnerBigSize[0]+'px; height: '+
inst.options.spinnerBigSize[1]+'px; background: transparent url('+
inst.options.spinnerBigImage+') no-repeat 0px 0px; z-index: 10;"></div>').mousedown(plugin._handleSpinner).mouseup(plugin._endSpinner).mouseout(plugin._endExpand).mousemove(plugin._describeSpinner).insertAfter(spinner);}},_getInput:function(spinner){return $(spinner).siblings('.'+plugin.markerClassName)[0];},_describeSpinner:function(event){var spinner=plugin._getSpinnerTarget(event);var inst=$.data(plugin._getInput(spinner),plugin.propertyName);spinner.title=inst.options.spinnerTexts[plugin._getSpinnerRegion(inst,event)];},_handleSpinner:function(event){var spinner=plugin._getSpinnerTarget(event);var input=plugin._getInput(spinner);if(plugin._isDisabledPlugin(input)){return;}
if(input==plugin._blurredInput){plugin._lastInput=input;plugin._blurredInput=null;}
var inst=$.data(input,plugin.propertyName);plugin._doFocus(input);var region=plugin._getSpinnerRegion(inst,event);plugin._changeSpinner(inst,spinner,region);plugin._actionSpinner(inst,region);plugin._timer=null;plugin._handlingSpinner=true;if(region>=3&&inst.options.spinnerRepeat[0]){plugin._timer=setTimeout(function(){plugin._repeatSpinner(inst,region);},inst.options.spinnerRepeat[0]);$(spinner).one('mouseout',plugin._releaseSpinner).one('mouseup',plugin._releaseSpinner);}},_actionSpinner:function(inst,region){if(!inst.input.val()){plugin._extractDatetime(inst);}
switch(region){case 0:this._setDatetime(inst);break;case 1:this._changeField(inst,-1,false);break;case 2:this._changeField(inst,+1,false);break;case 3:this._adjustField(inst,+1);break;case 4:this._adjustField(inst,-1);break;}},_repeatSpinner:function(inst,region){if(!plugin._timer){return;}
plugin._lastInput=plugin._blurredInput;this._actionSpinner(inst,region);this._timer=setTimeout(function(){plugin._repeatSpinner(inst,region);},inst.options.spinnerRepeat[1]);},_releaseSpinner:function(event){clearTimeout(plugin._timer);plugin._timer=null;},_endExpand:function(event){plugin._timer=null;var spinner=plugin._getSpinnerTarget(event);var input=plugin._getInput(spinner);var inst=$.data(input,plugin.propertyName);$(spinner).remove();inst._expanded=false;},_endSpinner:function(event){plugin._timer=null;var spinner=plugin._getSpinnerTarget(event);var input=plugin._getInput(spinner);var inst=$.data(input,plugin.propertyName);if(!plugin._isDisabledPlugin(input)){plugin._changeSpinner(inst,spinner,-1);}
if(plugin._handlingSpinner){plugin._lastInput=plugin._blurredInput;}
if(plugin._lastInput&&plugin._handlingSpinner){plugin._showField(inst);}
plugin._handlingSpinner=false;},_getSpinnerTarget:function(event){return event.target||event.srcElement;},_getSpinnerRegion:function(inst,event){var spinner=this._getSpinnerTarget(event);var pos=$(spinner).offset();var scrolled=[document.documentElement.scrollLeft||document.body.scrollLeft,document.documentElement.scrollTop||document.body.scrollTop];var left=(inst.options.spinnerIncDecOnly?99:event.clientX+scrolled[0]-pos.left);var top=event.clientY+scrolled[1]-pos.top;var spinnerSize=inst.options[inst._expanded?'spinnerBigSize':'spinnerSize'];var right=(inst.options.spinnerIncDecOnly?99:spinnerSize[0]-1-left);var bottom=spinnerSize[1]-1-top;if(spinnerSize[2]>0&&Math.abs(left-right)<=spinnerSize[2]&&Math.abs(top-bottom)<=spinnerSize[2]){return 0;}
var min=Math.min(left,top,right,bottom);return(min==left?1:(min==right?2:(min==top?3:4)));},_changeSpinner:function(inst,spinner,region){$(spinner).css('background-position','-'+((region+1)*inst.options[inst._expanded?'spinnerBigSize':'spinnerSize'][0])+'px 0px');},_extractDatetime:function(inst,set_range){var currentDatetime=this._parseDatetime(inst,inst.input.val())||this._normaliseDatetime(this._determineDatetime(inst,inst.options.defaultDatetime)||new Date());var fields=this._constrainTime(inst,[currentDatetime.getHours(),currentDatetime.getMinutes(),currentDatetime.getSeconds()]);if(set_range===undefined)set_range=true;inst._selectedYear=currentDatetime.getFullYear();inst._selectedMonth=currentDatetime.getMonth();inst._selectedDay=currentDatetime.getDate();inst._selectedHour=fields[0];inst._selectedMinute=fields[1];inst._selectedSecond=fields[2];inst._lastChr='';inst._field=inst.options.initialField>=0?Math.max(0,inst.options.initialField):inst._field;if(inst.input.val()!=''){this._showDatetime(inst,false,set_range);}},_parseDatetime:function(inst,value){if(!value){return null;}
var year=0;var month=0;var day=0;var hour=0;var minute=0;var second=0;var index=0;var datetimeFormat=inst.options.datetimeFormat;var skipNumber=function(){while(index<value.length&&value.charAt(index).match(/^[0-9]/)){index++;}};var i;for(i=0;i<datetimeFormat.length&&index<value.length;i++){var field=datetimeFormat.charAt(i);var num=parseInt(value.substring(index),10);if(field.match(/y|o|d|h|m|s/i)&&isNaN(num)){throw'Invalid date';}
num=(isNaN(num)?0:num);switch(field){case'y':case'Y':year=num;skipNumber();break;case'o':case'O':month=num;skipNumber();break;case'n':case'N':var monthNames=inst.options[field=='N'?'monthNames':'monthNamesShort'];for(var j=0;j<monthNames.length;j++){if(value.substring(index).substr(0,monthNames[j].length).toLowerCase()==monthNames[j].toLowerCase()){month=j+1;index+=monthNames[j].length;break;}}
break;case'w':case'W':var dayNames=inst.options[field=='W'?'dayNames':'dayNamesShort'];for(var j=0;j<dayNames.length;j++){if(value.substring(index).substr(0,dayNames[j].length).toLowerCase()==dayNames[j].toLowerCase()){index+=dayNames[j].length+1;break;}}
num=parseInt(value.substring(index),10);num=(isNaN(num)?0:num);case'd':case'D':day=num;skipNumber();break;case'h':case'H':hour=num;skipNumber();break;case'm':case'M':minute=num;skipNumber();break;case's':case'S':second=num;skipNumber();break;case'a':case'A':var pm=(value.substr(index,inst.options.ampmNames[1].length).toLowerCase()==inst.options.ampmNames[1].toLowerCase());hour=(hour==12?0:hour)+(pm?12:0);index+=inst.options.ampmNames[0].length;break;default:index++;}}
if(i<datetimeFormat.length){throw'Invalid date';}
year+=(year>=100||datetimeFormat.indexOf('y')==-1?0:(year>this._shortYearCutoff(inst)?1900:2000));var fields=this._constrainTime(inst,[hour,minute,second]);var date=new Date(year,Math.max(0,month-1),day,fields[0],fields[1],fields[2]);if(datetimeFormat.match(/y|o|n|d|w/i)&&(date.getFullYear()!=year||date.getMonth()+1!=month||date.getDate()!=day)){throw'Invalid date';}
return date;},_showDatetime:function(inst,initial,set_range){this._setValue(inst,this._formatDatetime(inst,inst.options.datetimeFormat));this._showField(inst,initial,set_range);},_formatDatetime:function(inst,format){var currentDatetime='';var ampm=format.toLowerCase().indexOf('a')>-1;for(var i=0;i<format.length;i++){var field=format.charAt(i);switch(field){case'y':currentDatetime+=this._formatNumber(inst._selectedYear%100);break;case'Y':currentDatetime+=this._formatNumber(inst._selectedYear,4);break;case'o':case'O':currentDatetime+=this._formatNumber(inst._selectedMonth+1,field=='o'?1:2);break;case'n':case'N':currentDatetime+=inst.options[field=='N'?'monthNames':'monthNamesShort'][inst._selectedMonth];break;case'd':case'D':currentDatetime+=this._formatNumber(inst._selectedDay,field=='d'?1:2);break;case'w':case'W':currentDatetime+=inst.options[field=='W'?'dayNames':'dayNamesShort']
[new Date(inst._selectedYear,inst._selectedMonth,inst._selectedDay).getDay()]+' '+this._formatNumber(inst._selectedDay);break;case'h':case'H':currentDatetime+=this._formatNumber(!ampm?inst._selectedHour:inst._selectedHour%12||12,field=='h'?1:2);break;case'm':case'M':currentDatetime+=this._formatNumber(inst._selectedMinute,field=='m'?1:2);break;case's':case'S':currentDatetime+=this._formatNumber(inst._selectedSecond,field=='s'?1:2);break;case'a':case'A':var a_m=inst.options.ampmNames[inst._selectedHour<12?0:1];currentDatetime+=field=='A'?a_m:a_m.toLowerCase();break;default:currentDatetime+=field;break;}}
return currentDatetime;},_showField:function(inst,initial,show_range){var input=inst.input[0];if(inst.input.is(':hidden')||plugin._lastInput!=input){return;}
if(show_range===undefined)show_range=true;if(initial===true&&inst.options.initialField<0){inst._field=plugin._getField(input);}
var start=0;for(var i=0;i<inst._fields[inst._field];i++){start+=this._fieldLength(inst,inst.options.datetimeFormat.charAt(i));}
var end=start+this._fieldLength(inst,inst.options.datetimeFormat.charAt(i));if(input.setSelectionRange){if(show_range){input.setSelectionRange(start,end);}}
else if(input.createTextRange){var range=input.createTextRange();range.moveStart('character',start);range.moveEnd('character',end-inst.input.val().length);range.select();}
if(!input.disabled){input.focus();}},_fieldLength:function(inst,format){switch(format){case'Y':return 4;case'n':case'N':return inst.options[format=='N'?'monthNames':'monthNamesShort']
[inst._selectedMonth].length;case'w':case'W':return inst.options[format=='W'?'dayNames':'dayNamesShort']
[new Date(inst._selectedYear,inst._selectedMonth,inst._selectedDay).getDay()].length+3;case'y':case'O':case'D':case'H':case'M':case'S':return 2;case'o':return(''+(inst._selectedMonth+1)).length;case'd':return(''+inst._selectedDay).length;case'h':return(''+(inst._ampmField==-1?inst._selectedHour:inst._selectedHour%12||12)).length;case'm':return(''+inst._selectedMinute).length;case's':return(''+inst._selectedSecond).length;case'a':case'A':return inst.options.ampmNames[0].length;default:return 1;}},_formatNumber:function(value,length){value=''+value;length=length||2;while(value.length<length){value='0'+value;}
return value;},_setValue:function(inst,value){if(value!=inst.input.val()){if(inst.options.altField){$(inst.options.altField).val(!value?'':this._formatDatetime(inst,inst.options.altFormat||inst.options.datetimeFormat));}
inst.input.val(value).trigger('change');}},_changeField:function(inst,offset,moveOut){var atFirstLast=(inst.input.val()==''||inst._field==(offset==-1?0:inst._fields.length-1));if(!atFirstLast){inst._field+=offset;}
this._showField(inst);inst._lastChr='';return(atFirstLast&&moveOut);},_adjustField:function(inst,offset){if(inst.input.val()==''){offset=0;}
var field=inst.options.datetimeFormat.charAt(inst._fields[inst._field]);var year=inst._selectedYear+(field.match(/y/i)?offset:0);var month=inst._selectedMonth+(field.match(/o|n/i)?offset:0);var day=(field.match(/d|w/i)?inst._selectedDay+offset:Math.min(inst._selectedDay,this._getDaysInMonth(year,month)));var timeSteps=inst.options.timeSteps;var hour=inst._selectedHour+(field.match(/h/i)?offset*timeSteps[0]:0)+
(field.toLowerCase()=='a'&&offset!=0?(inst._selectedHour<12?+12:-12):0);var minute=inst._selectedMinute+(field.match(/m/i)?offset*timeSteps[1]:0);var second=inst._selectedSecond+(field.match(/s/i)?offset*timeSteps[2]:0);this._setDatetime(inst,new Date(year,month,day,hour,minute,second));},_getDaysInMonth:function(year,month){return new Date(year,month+1,0,12).getDate();},_setDatetime:function(inst,datetime){datetime=this._normaliseDatetime(this._determineDatetime(inst,datetime||inst.options.defaultDatetime)||new Date());var fields=this._constrainTime(inst,[datetime.getHours(),datetime.getMinutes(),datetime.getSeconds()]);datetime.setHours(fields[0],fields[1],fields[2]);var minDatetime=this._normaliseDatetime(this._determineDatetime(inst,inst.options.minDatetime));var maxDatetime=this._normaliseDatetime(this._determineDatetime(inst,inst.options.maxDatetime));var minTime=this._normaliseDatetime(this._determineDatetime(inst,inst.options.minTime),'d');var maxTime=this._normaliseDatetime(this._determineDatetime(inst,inst.options.maxTime),'d');datetime=(minDatetime&&datetime<minDatetime?minDatetime:(maxDatetime&&datetime>maxDatetime?maxDatetime:datetime));if(minTime&&this._normaliseDatetime(new Date(datetime.getTime()),'d')<minTime){this._copyTime(minTime,datetime);}
if(maxTime&&this._normaliseDatetime(new Date(datetime.getTime()),'d')>maxTime){this._copyTime(maxTime,datetime);}
inst._selectedYear=datetime.getFullYear();inst._selectedMonth=datetime.getMonth();inst._selectedDay=datetime.getDate();inst._selectedHour=datetime.getHours();inst._selectedMinute=datetime.getMinutes();inst._selectedSecond=datetime.getSeconds();this._showDatetime(inst,false,true);},_copyDate:function(dateFrom,dateTo){dateTo.setFullYear(dateFrom.getFullYear());dateTo.setMonth(dateFrom.getMonth());dateTo.setDate(dateFrom.getDate());},_copyTime:function(timeFrom,timeTo){timeTo.setHours(timeFrom.getHours());timeTo.setMinutes(timeFrom.getMinutes());timeTo.setSeconds(timeFrom.getSeconds());},_determineDatetime:function(inst,setting){var offsetNumeric=function(offset){var datetime=new Date();datetime.setSeconds(datetime.getSeconds()+offset);return datetime;};var offsetString=function(offset){var datetime;try{datetime=plugin._parseDatetime(inst,offset);if(datetime){return datetime;}}
catch(e){}
offset=offset.toLowerCase();datetime=new Date();var year=datetime.getFullYear();var month=datetime.getMonth();var day=datetime.getDate();var hour=datetime.getHours();var minute=datetime.getMinutes();var second=datetime.getSeconds();var pattern=/([+-]?[0-9]+)\s*(s|m|h|d|w|o|y)?/g;var matches=pattern.exec(offset);while(matches){switch(matches[2]||'s'){case's':second+=parseInt(matches[1],10);break;case'm':minute+=parseInt(matches[1],10);break;case'h':hour+=parseInt(matches[1],10);break;case'd':day+=parseInt(matches[1],10);break;case'w':day+=parseInt(matches[1],10)*7;break;case'o':month+=parseInt(matches[1],10);break;case'y':year+=parseInt(matches[1],10);break;}
matches=pattern.exec(offset);}
return new Date(year,month,day,hour,minute,second);};return(setting?(typeof setting=='string'?offsetString(setting):(typeof setting=='number'?offsetNumeric(setting):setting)):null);},_normaliseDatetime:function(datetime,type){if(!datetime){return null;}
if(type=='d'){datetime.setFullYear(0);datetime.setMonth(0);datetime.setDate(0);}
if(type=='t'){datetime.setHours(12);datetime.setMinutes(0);datetime.setSeconds(0);}
datetime.setMilliseconds(0);return datetime;},_handleKeyPress:function(inst,chr){chr=chr.toLowerCase();var field=inst.options.datetimeFormat.charAt(inst._fields[inst._field]);var sep=inst.options.datetimeFormat.charAt(inst._fields[inst._field]+1);sep=('yYoOnNdDwWhHmMsSa'.indexOf(sep)==-1?sep:'');if((inst.options.datetimeSeparators+sep).indexOf(chr)>-1){this._changeField(inst,+1,false);}
else if(chr>='0'&&chr<='9'){var key=parseInt(chr,10);var value=parseInt(inst._lastChr+chr,10);var year=(!field.match(/y/i)?inst._selectedYear:value);var month=(!field.match(/o|n/i)?inst._selectedMonth+1:(value>=1&&value<=12?value:(key>0?key:inst._selectedMonth+1)));var day=(!field.match(/d|w/i)?inst._selectedDay:(value>=1&&value<=this._getDaysInMonth(year,month-1)?value:(key>0?key:inst._selectedDay)));var hour=(!field.match(/h/i)?inst._selectedHour:(inst._ampmField==-1?(value<24?value:key):(value>=1&&value<=12?value:(key>0?key:inst._selectedHour))%12+(inst._selectedHour>=12?12:0)));var minute=(!field.match(/m/i)?inst._selectedMinute:(value<60?value:key));var second=(!field.match(/s/i)?inst._selectedSecond:(value<60?value:key));var fields=this._constrainTime(inst,[hour,minute,second]);var shortYearCutoff=this._shortYearCutoff(inst);if(year<10){if(year==2){year=new Date().getFullYear();}else{year=Math.floor(new Date().getFullYear()/10)*10+year;}}
this._setDatetime(inst,new Date(year+(year>=100||field!='y'?0:(year>shortYearCutoff?1900:2000)),month-1,day,fields[0],fields[1],fields[2]));inst._lastChr=(field!='Y'?'':inst._lastChr.substr(Math.max(0,inst._lastChr.length-2)))+chr;}
else if(field.match(/n/i)){inst._lastChr+=chr;var names=inst.options[field=='n'?'monthNamesShort':'monthNames'];var findMonth=function(){for(var i=0;i<names.length;i++){if(names[i].toLowerCase().substring(0,inst._lastChr.length)==inst._lastChr){return i;break;}}
return-1;};var month=findMonth();if(month==-1){inst._lastChr=chr;month=findMonth();}
if(month==-1){inst._lastChr='';}
else{var year=inst._selectedYear;var day=Math.min(inst._selectedDay,this._getDaysInMonth(year,month));this._setDatetime(inst,this._normaliseDatetime(new Date(year,month,day,inst._selectedHour,inst._selectedMinute,inst._selectedSecond)));}}
else if(inst._ampmField>-1){if((chr==inst.options.ampmNames[0].substring(0,1).toLowerCase()&&inst._selectedHour>=12)||(chr==inst.options.ampmNames[1].substring(0,1).toLowerCase()&&inst._selectedHour<12)){var saveField=inst._field;inst._field=inst._ampmField;this._adjustField(inst,+1);inst._field=saveField;this._showField(inst);}}},_shortYearCutoff:function(inst){var cutoff=inst.options.shortYearCutoff;if(typeof cutoff=='string'){cutoff=new Date().getFullYear()+parseInt(cutoff,10);}
return cutoff%100;},_constrainTime:function(inst,fields){var specified=(fields!=null);if(!specified){var now=this._determineTime(inst,inst.options.defaultTime)||new Date();fields=[now.getHours(),now.getMinutes(),now.getSeconds()];}
var reset=false;var timeSteps=inst.options.timeSteps;for(var i=0;i<timeSteps.length;i++){if(reset){fields[i]=0;}
else if(timeSteps[i]>1){fields[i]=Math.round(fields[i]/timeSteps[i])*timeSteps[i];reset=true;}}
return fields;}});var getters=['getDatetime','getOffset','isDisabled'];function isNotChained(command,otherArgs){if(command=='option'&&(otherArgs.length==0||(otherArgs.length==1&&typeof otherArgs[0]=='string'))){return true;}
return $.inArray(command,getters)>-1;}
$.fn.datetimeEntry=function(options){var otherArgs=Array.prototype.slice.call(arguments,1);if(isNotChained(options,otherArgs)){return plugin['_'+options+'Plugin'].apply(plugin,[this[0]].concat(otherArgs));}
return this.each(function(){if(typeof options=='string'){if(!plugin['_'+options+'Plugin']){throw'Unknown command: '+options;}
plugin['_'+options+'Plugin'].apply(plugin,[this].concat(otherArgs));}
else{var inlineSettings=($.fn.metadata?$(this).metadata():{});plugin._attachPlugin(this,$.extend({},inlineSettings,options||{}));}});};var plugin=$.datetimeEntry=new DatetimeEntry();})(jQuery);