$.editable.addInputType("radiobutton", {
	/* This uses default hidden input field. No need for element() function. */
	submit: function (settings, original) {
		var retvalue, i = 0, value=$('[name=jeditable_rb]', this);
		while( i < value.length ) {
			if (value[i].checked) {
				retvalue = $(value[i]).val();
				i = value.length;
			}
			i++;
		}
		$('input', this).val(retvalue);
	},
    content : function(data, settings, original) {
		var id;
        /* If it is string assume it is json. */
        if (String == data.constructor) {      
            eval ('var json = ' + data);
        } else {
        /* Otherwise assume it is a hash already. */
            var json = data;
        }
		id = Math.floor(Math.random()*20198);
        for (var key in json) {
            if (!json.hasOwnProperty(key)) {
                continue;
            }
            if ('checked' == key) {
                continue;
            } 
			// .append(json[key])
            var option = $('<label><input name="jeditable_rb" value="'+key+'" type="radio" />'+json[key]+'</label><br />');
            $(this).append(option);
        }                    
        /* Loop option again to set selected. IE needed this... */ 
        $(this).children().each(function() {
            if ($(this).val() == json['checked'] || 
                $(this).text() == $.trim(original.revert)) {
                    $(this).children(":first").attr('checked', 'checked');
            }
        });
    }
});

$.editable.addInputType('textright', {
	element : function(settings, original) {
    	var input = $('<input class="right" />');
    	if (settings.width  != 'none') { input.width(settings.width);  }
    	if (settings.height != 'none') { input.height(settings.height); }
    	/* https://bugzilla.mozilla.org/show_bug.cgi?id=236791 */
    	//input[0].setAttribute('autocomplete','off');
    	input.attr('autocomplete','off');
    	$(this).append(input);
    	return(input);
	}
});


$.editable.addInputType('autosize', {
    element : function(settings, original) {
        var textarea = $('<textarea class="autosize_animate" />');
        if (settings.rows) {
            textarea.attr('rows', settings.rows);
        } else {
            textarea.height(settings.height);
        }
        if (settings.cols) {
            textarea.attr('cols', settings.cols);
        } else {
            textarea.width(settings.width);
        }
        $(this).append(textarea);
        return(textarea);
    },
    plugin : function(settings, original) {
		var autosize_options = {append: "\n"};
		$.extend(autosize_options, settings.autosize);   
        $('textarea', this).autosize(autosize_options);
    }
});


$.editable.addInputType('timepicker', {
	element: function(settings, original) {
		var input = $('<input class="time_input" />');
		if (!window.Modernizr.inputtypes.time || !is_touch_device()) {
			input.timepicker({
			    buttonImage: "lib/external/jquery/css/images/calendar.png",
			    timeFormat: jquery_time,
			    addSliderAccess: true,
			    sliderAccessArgs: { touchonly: false }
			});
		} else {
			input.attr('type', 'time');
			settings.cancel = null;
			settings.submit = null;
			settings.onblur = 'submit';
		}
		$(this).append(input);
		return (input);
	}
});

$.editable.addInputType('datepicker', {
	element: function(settings, original) {
		var input = $('<input class="date_input" />');
		if (!window.Modernizr.inputtypes.date || !is_touch_device()) {
			input.datepicker({
				dateFormat: jquery_date,
				showButtonPanel: true,
				changeYear: true,
				changeMonth: true,
				showWeek: true,
				onSelect: function(dateText, inst) {
					// $(this).parents("form").submit();
				}
			});
			$("#ui-datepicker-div").draggable();
		} else {
			input.attr('type', 'date');
			settings.cancel = null;
			settings.submit = null;
			settings.onblur = 'submit';
		}
		$(this).append(input);
		return (input);
	}
});

$.editable.addInputType('datetimepicker', {
	element: function(settings, original) {
		var format, ampm_val, input, showSecond = true;
		
		ampm_val = jquery_time.charAt(jquery_time.length-1).toUpperCase() == 'T' ? true : false;

		input = $('<input class="datetime_input" />');
		format = $(original).attr('data-format');
		time_format= jquery_time;
		if (format!==undefined) {
			var has_sec = $(original).attr('data-format').indexOf(':s');
			if (has_sec<0) {
				time_format = time_format.replace(':ss', '');
				time_format = time_format.replace('.ss', '');
				showSecond = false;
			}
		}
		if (!window.Modernizr.inputtypes['datetime-local'] || !is_touch_device()) {
			input.datetimepicker({
				dateFormat: jquery_date,
				timeFormat: time_format,
				showSecond: showSecond,
				showButtonPanel: true,
				ampm: ampm_val,
				changeYear: true,
				changeMonth: true,
				showWeek: true,
				onSelect: function(dateText, inst) {
					$(input).val($.trim($(input).val()+' '+$('#ui_tpicker_time_'+$(this).attr('id')).text()));
					$('.ui-timepicker-div').height($('.ui-timepicker-div').height());
					$(input).focus();
					// $(this).parents("form").submit();
				},
				beforeShow: function (textbox, instance) {
					var left, top, left;
					var from_right = ($(window).width() - ($(textbox).offset().left + $(textbox).outerWidth()));
					var from_bottom = $(window).height() - $(textbox).viewportOffset().top;
					var dtp_width = instance.dpDiv.width();
					var dtp_height = instance.dpDiv.height();
					if (from_right<dtp_width) {
						left = (-(dtp_width+10)) + 'px';
					} else {
						left = textbox.offsetWidth + 'px';
					}
					if (from_bottom<dtp_height) {
						instance.dpDiv.css({ 
							marginTop: (from_bottom - $(textbox).outerHeight())+'px',
							marginLeft: left 
						});
					} else {
						if (from_right<dtp_width) {
							instance.dpDiv.css({
								marginTop: (-textbox.offsetHeight) + 'px',
								marginLeft: left
							});
						} else {
							instance.dpDiv.css({
								marginTop: (-textbox.offsetHeight) + 'px',
								marginLeft: left
							});
						}
					}
				}
			});
			$("#ui-datepicker-div").draggable();
		} else {
			input.attr('type', 'datetime-local');
			settings.cancel = null;
			settings.submit = null;
			settings.onblur = 'submit';
		}
		$(this).append(input);
		return (input);
	}
});