/*
 * 
 * TableSorter 2.0 - Client-side table sorting with ease!
 * Version 2.0.3
 * @requires jQuery v1.2.3
 * 
 * Copyright (c) 2007 Christian Bach
 * Examples and docs at: http://tablesorter.com
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Changes to include more refined detection of the datatype by myDBR.com
 */
(function($){$.extend({tablesorter:new function(){var parsers=[],widgets=[];this.defaults={cssHeader:"header",cssAsc:"headerSortUp",cssDesc:"headerSortDown",sortInitialOrder:"",sortMultiSortKey:"shiftKey",sortForce:null,sortAppend:null,textExtraction:"complex",parsers:{},widgets:[],widgetZebra:{css:["even","odd"]},headers:{},widthFixed:false,cancelSelection:true,sortList:[],headerList:[],dateFormat:sortdateformat,decimal:decimal_separator,thousandSeparator:thousand_separator,debug:false,lastHeaderRowOnly:true,skipHeaderWithCSS:'unsortable'};function benchmark(s,d){log(s+","+(new Date().getTime()-d.getTime())+"ms");}
this.benchmark=benchmark;function log(s){if(typeof console!="undefined"&&typeof console.debug!="undefined"){console.log(s);}else{alert(s);}}
function buildParserCache(table,$headers,only_sorting){var list=[],sort_order_fixed;if(table.config.debug){var parsersDebug="";}
if(table.tBodies.length>0){var rows=table.tBodies[0].rows,celldata;if(table.tBodies[0].rows[0]){var cells=rows[0].cells,l=cells.length;for(var i=0;i<l;i++){var p=false;if($($headers[i]).attr('data-sortorder')){sort_order_fixed=$($headers[i]).attr('data-sortorder');}else{sort_order_fixed=undefined;}
if($($headers[i]).attr('data-sortmethod')){p=getParserById($($headers[i]).attr('data-sortmethod'));}else if($.metadata&&($($headers[i]).metadata()&&$($headers[i]).metadata().sorter)){p=getParserById($($headers[i]).metadata().sorter);}else if((table.config.headers[i]&&table.config.headers[i].sorter)){p=getParserById(table.config.headers[i].sorter);}
if(!p){celldata=cells[i];if(celldata.innerHTML==''){var row_num=1;while(row_num<rows.length){if(rows[row_num].children.length>i&&rows[row_num].cells[i].innerHTML!=''){celldata=rows[row_num].cells[i];break;}
row_num++;}}
p=detectParserForColumn(table,celldata);}
if(table.config.debug){parsersDebug+="column:"+i+" parser:"+p.id+"\n";}
if(typeof only_sorting==='undefined'){list.push(p);}else{sort_info={};if(sort_order_fixed!==undefined){sort_info.sort_order_fixed=sort_order_fixed;}
sort_info.sorting=p.sorting;list.push(sort_info);}}}}
if(table.config.debug){log(parsersDebug);}
return list;};function detectParserForColumn(table,node){var l=parsers.length;for(var i=1;i<l;i++){if(parsers[i].is($.trim(getElementText(table.config,node)),table,node)){return parsers[i];}}
return parsers[0];}
function getParserById(name){var l=parsers.length;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==name.toLowerCase()){return parsers[i];}}
return false;}
function buildCache(table){var cache={row:[],normalized:[]};if(table.config.debug){var cacheTime=new Date();}
if(table.tBodies.length>0){var totalRows=(table.tBodies[0]&&table.tBodies[0].rows.length)||0,totalCells=(table.tBodies[0].rows[0]&&table.tBodies[0].rows[0].cells.length)||0,parsers=table.config.parsers;for(var i=0;i<totalRows;++i){var r=table.tBodies[0].rows[i];if(!$(r).hasClass('sortbottom')){var c=table.tBodies[0].rows[i],cols=[];cache.row.push($(c));for(var j=0;j<totalCells;++j){cols.push(parsers[j].format(getElementText(table.config,c.cells[j]),table,c.cells[j]));}
cols.push(i);cache.normalized.push(cols);cols=null;}};if(table.config.debug){benchmark("Building cache for "+totalRows+" rows:",cacheTime);}}
return cache;};function getElementText(config,node){if(!node)return"";var t="";if(config.textExtraction=="simple"){if(node.childNodes[0]&&node.childNodes[0].hasChildNodes()){t=node.childNodes[0].innerHTML;}else{t=node.innerHTML;}}else{if(typeof(config.textExtraction)=="function"){t=config.textExtraction(node);}else{t=$(node).text();}}
return t;}
function appendToTable(table,cache){if(table.config.debug){var appendTime=new Date();}
var c=cache,r=c.row,n=c.normalized,totalRows=n.length,checkCell=(totalRows>0)?(n[0].length-1):0,tableBody=$(table.tBodies[0]),rows=[];for(var i=0;i<totalRows;i++){var hasFooter;rows.push(r[n[i][checkCell]]);if(!table.config.appender){var o=r[n[i][checkCell]];var l=o.length;var tablelen=tableBody[0].rows.length;if($(tableBody[0].rows[tablelen-1]).hasClass("sortbottom")){hasFooter=true;}else{hasFooter=false;}
for(var j=0;j<l;j++){if(!hasFooter){tableBody[0].appendChild(o[j]);}else{tableBody[0].insertBefore(o[j],tableBody[0].rows[tablelen-1]);}}}}
if(table.config.appender){table.config.appender(table,rows);}
rows=null;if(table.config.debug){benchmark("Rebuilt table:",appendTime);}
applyWidget(table);setTimeout(function(){$(table).trigger("sortEnd");},0);};function buildHeaders(table){if(table.config.debug){var time=new Date();}
var meta=($.metadata)?true:false,tableHeadersRows=[];for(var i=0;i<table.tHead.rows.length;i++){tableHeadersRows[i]=0;};var sort_meta,parserCache_tmp,thselector=(table.config.lastHeaderRowOnly)?"thead tr:not('.columnfilter'):last th":"thead th";sort_meta=$('meta[name=tablesorter-default-sorting]').attr('content');if(sort_meta!==undefined){table.config.sortInitialOrder=sort_meta;}
$tableHeaders=$(thselector,table);parserCache_tmp=buildParserCache(table,$tableHeaders,true);$tableHeaders.each(function(index){var nosort;this.column=index;if(typeof(parserCache_tmp[index])==='undefined'){this.order=0;}else{if(typeof(parserCache_tmp[index]['sort_order_fixed'])!=='undefined'){this.order=formatSortingOrder(parserCache_tmp[index]['sort_order_fixed']);}else{if(table.config.sortInitialOrder!=''){this.order=formatSortingOrder(table.config.sortInitialOrder);}else{this.order=formatSortingOrder(parserCache_tmp[index].sorting);}}}
this.count=this.order;if(table.config.skipHeaderWithCSS.length>0){nosort=$(this).hasClass(table.config.skipHeaderWithCSS);}else{nosort=false;}
if(nosort||checkHeaderMetadata(this)||checkHeaderOptions(table,index))this.sortDisabled=true;if(!this.sortDisabled){$(this).addClass(table.config.cssHeader);}
table.config.headerList[index]=this;});if(table.config.debug){benchmark("Built headers:",time);log($tableHeaders);}
return $tableHeaders;};function checkCellColSpan(table,rows,row){var arr=[],r=table.tHead.rows,c=r[row].cells;for(var i=0;i<c.length;i++){var cell=c[i];if(cell.colSpan>1){arr=arr.concat(checkCellColSpan(table,headerArr,row++));}else{if(table.tHead.length==1||(cell.rowSpan>1||!r[row+1])){arr.push(cell);}}}
return arr;};function checkHeaderMetadata(cell){if(($.metadata)&&($(cell).metadata().sorter===false)){return true;};return false;}
function checkHeaderOptions(table,i){if((table.config.headers[i])&&(table.config.headers[i].sorter===false)){return true;};return false;}
function applyWidget(table){var c=table.config.widgets;var l=c.length;for(var i=0;i<l;i++){getWidgetById(c[i]).format(table);}}
function getWidgetById(name){var l=widgets.length;for(var i=0;i<l;i++){if(widgets[i].id.toLowerCase()==name.toLowerCase()){return widgets[i];}}
return widgets[i];};function formatSortingOrder(v){if(typeof(v)!="Number"){i=(v.toLowerCase()=="desc")?1:0;}else{i=(v==(0||1))?v:0;}
return i;}
function isValueInArray(v,a){var l=a.length;for(var i=0;i<l;i++){if(a[i][0]==v){return true;}}
return false;}
function setHeadersCss(table,$headers,list,css){$headers.removeClass(css[0]).removeClass(css[1]);var h=[];$headers.each(function(offset){if(!this.sortDisabled){h[this.column]=$(this);}});var l=list.length;for(var i=0;i<l;i++){h[list[i][0]].addClass(css[list[i][1]]);}}
function fixColumnWidth(table,$headers){var c=table.config;if(c.widthFixed){var colgroup=$('<colgroup>');$("tr:first td",table.tBodies[0]).each(function(){colgroup.append($('<col>').css('width',$(this).width()));});$(table).prepend(colgroup);};}
function updateHeaderSortCount(table,sortList){var c=table.config,l=sortList.length;for(var i=0;i<l;i++){var s=sortList[i],o=c.headerList[s[0]];o.count=s[1];o.count++;}}
function multisort(table,sortList,cache){var i,c,orgOrderCol;$(table).find('.inline_report').remove();if($(table).find('thead tr:last').children().size()){$(table.caption).find("span.sorttip").css('display','block');}
if(table.config.debug){var sortTime=new Date();}
var dynamicExp="var sortWrapper = function(a,b) {",l=sortList.length;for(i=0;i<l;i++){c=sortList[i][0];var order=sortList[i][1];var s=(getCachedSortType(table.config.parsers,c)=="text")?((order==0)?"sortText":"sortTextDesc"):((order==0)?"sortNumeric":"sortNumericDesc");var e="e"+i;dynamicExp+="var "+e+" = "+s+"(a["+c+"],b["+c+"]); ";dynamicExp+="if("+e+") { return "+e+"; } ";dynamicExp+="else { ";}
if(cache.normalized.length>0){orgOrderCol=cache.normalized[0].length-1;}else{orgOrderCol=0;}
dynamicExp+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(i=0;i<l;i++){dynamicExp+="}; ";}
dynamicExp+="return 0; ";dynamicExp+="}; ";var hdr_changes=[];$(table).find('tr.hdr_change').each(function(){hdr_changes.push($(this).index());});eval(dynamicExp);$(table).find('tr').removeClass('hdr_change');var cache_current={row:[],normalized:[]};var cache_out={row:[],normalized:[]};var header_first_row_visibility,span;var header_other_row_visibility,visible_first,visible_other;var cacherows=0;var last_dataset;var data_set_changed;var force_last_check=false;if(cache.row.length>0){last_dataset=cache.row[0].attr('data-set');}
for(i=0;i<cache.row.length;i++){data_set_changed=(cache.row[i].attr('data-set')!=last_dataset);if(!data_set_changed&&!cache.row[i].hasClass('summary_row')&&i==(cache.row.length-1)){force_last_check=true;cache_current.row.push(cache.row[i]);cache_current.normalized.push(cache.normalized[i]);}
if((force_last_check)||(data_set_changed)||(cache.row[i].hasClass('summary_row'))){if(cache_current.row.length>0){header_first_row_visibility=[];header_other_row_visibility=[];var row1_cells=cache_current.row[0].children();if(cache_current.row.length>1){var row_other_cells=cache_current.row[1].children();for(var col=0;col<row1_cells.length;col++){visible_first=-1;visible_other=-1;if($(row1_cells[col]).find('span.hdr_show').length>0){visible_first=1;}
if($(row1_cells[col]).find('span.hdr_hide').length>0){visible_first=0;}
if($(row_other_cells[col]).find('span.hdr_hide').length>0){visible_other=0;}
if($(row_other_cells[col]).find('span.hdr_show').length>0){visible_other=1;}
if(visible_first>=0){header_first_row_visibility[col]=visible_first;}
if(visible_other>=0){header_other_row_visibility[col]=visible_other;}}}
cacherows=i-cache_current.normalized.length;cache_current.normalized.sort(sortWrapper);if((header_other_row_visibility.length>0)||(header_first_row_visibility.length>0)){var next_set_row_num=cache_out.row.length;for(var row=0;row<cache_current.row.length;row++){var row_ref_index=cache_current.normalized[row].length-1;for(var rownum=0;rownum<cache_current.normalized.length;rownum++){if(row+cacherows==cache_current.normalized[rownum][row_ref_index]){break;}};row_other_cells=cache_current.row[row].children();if(next_set_row_num==rownum+cacherows){for(col in header_first_row_visibility){span=$(row_other_cells[col]).find('span').first();if(header_first_row_visibility[col]>0){span.addClass('hdr_show');span.removeClass('hdr_hide');}else{span.addClass('hdr_hide');span.removeClass('hdr_show');}}}else{for(col in header_other_row_visibility){span=$(row_other_cells[col]).find('span').first();if(header_other_row_visibility[col]>0){span.addClass('hdr_show');span.removeClass('hdr_hide');}else{span.addClass('hdr_hide');span.removeClass('hdr_show');}}}}}
for(c=0;c<cache_current.row.length;c++){cache_out.row.push(cache_current.row[c]);cache_out.normalized.push(cache_current.normalized[c]);}}
if((data_set_changed)||(cache.row[i].hasClass('summary_row'))){cache_current={row:[],normalized:[]};last_dataset=cache.row[i].attr('data-set');}
cache_current.row.push(cache.row[i]);cache_current.normalized.push(cache.normalized[i]);}else{cache_current.row.push(cache.row[i]);cache_current.normalized.push(cache.normalized[i]);}}
if(cache_current.row.length>0){cache_current.normalized.sort(sortWrapper);for(c=0;c<cache_current.row.length;c++){cache_out.row.push(cache_current.row[c]);cache_out.normalized.push(cache_current.normalized[c]);}}
$(hdr_changes).each(function(index,val){cache_out.row[cache_out.normalized[val][cache_out.normalized[val].length-1]].addClass('hdr_change');});if(table.config.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time:",sortTime);}
return cache_out;};function sortText(a,b){return((a<b)?-1:((a>b)?1:0));};function sortTextDesc(a,b){return((b<a)?-1:((b>a)?1:0));};function sortNumeric(a,b){return a-b;};function sortNumericDesc(a,b){return b-a;};function getCachedSortType(parsers,i){return parsers[i].type;};this.construct=function(settings){return this.each(function(){if(!this.tHead||!this.tBodies)return;var $this,$document,$headers,cache,config,shiftDown=0,sortOrder;this.config={};this.config.hasInitialized=false;config=$.extend(this.config,$.tablesorter.defaults,settings);$this=$(this);$headers=buildHeaders(this);this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);var sortCSS=[config.cssDesc,config.cssAsc];fixColumnWidth(this);$headers.click(function(e){$this.find('.inline_report').remove();$this.trigger("sortStart");var j,totalRows=($this[0].tBodies[0]&&$this[0].tBodies[0].rows.length)||0;if(!this.sortDisabled&&totalRows>0){var $cell=$(this);var i=this.column;this.order=this.count++%2;if(!e[config.sortMultiSortKey]){config.sortList=[];if(config.sortForce!=null){var a=config.sortForce;for(j=0;j<a.length;j++){if(a[j][0]!=i){config.sortList.push(a[j]);}}}
config.sortList.push([i,this.order]);}else{if(isValueInArray(i,config.sortList)){for(j=0;j<config.sortList.length;j++){var s=config.sortList[j],o=config.headerList[s[0]];if(s[0]==i){o.count=s[1];o.count++;s[1]=o.count%2;}}}else{config.sortList.push([i,this.order]);}};setTimeout(function(){setHeadersCss($this[0],$headers,config.sortList,sortCSS);appendToTable($this[0],multisort($this[0],config.sortList,cache));$this.trigger("update");},1);return false;}}).mousedown(function(){if(config.cancelSelection){this.onselectstart=function(){return false;};return false;}});$this.bind("update",function(){this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);}).bind("sorton",function(e,list){$(this).trigger("sortStart");e.stopPropagation();config.sortList=list;var sortList=config.sortList;updateHeaderSortCount(this,sortList);setHeadersCss(this,$headers,sortList,sortCSS);appendToTable(this,multisort(this,sortList,cache));}).bind("appendCache",function(){appendToTable(this,cache);}).bind("applyWidgetId",function(e,id){getWidgetById(id).format(this);}).bind("applyWidgets",function(){applyWidget(this);});if($.metadata&&($(this).metadata()&&$(this).metadata().sortlist)){config.sortList=$(this).metadata().sortlist;}
if(config.sortList.length>0){$this.trigger("sorton",[config.sortList]);}
applyWidget(this);this.config.hasInitialized=true;});};this.addParser=function(parser){var l=parsers.length,a=true;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==parser.id.toLowerCase()){a=false;}}
if(a){parsers.push(parser);};};this.addWidget=function(widget){widgets.push(widget);};this.formatFloat=function(s){var i=parseFloat(s);return(isNaN(i))?0:i;};this.formatInt=function(s){var i=parseInt(s,10);return(isNaN(i))?0:i;};this.isDigit=function(s,config){return(s.match(/^[£$Ä€¢¥<>]\s?[-+]?\d/)||s.match(/^[-+]?\d+[,\.\s]?(\d+)\s/)||s.match(/^[-+]?(\d+[,\.]?)+(E[-+][\d]+)?%?$/)||s.match(/^( ?\d?\d?\d+)+([,\.]\d+)?/));};this.clearTableBody=function(table){if($.browser.msie){function empty(){while(this.firstChild)this.removeChild(this.firstChild);}
empty.apply(table.tBodies[0]);}else{table.tBodies[0].innerHTML="";}};}});$.fn.extend({tablesorter:$.tablesorter.construct});var ts=$.tablesorter;ts.addParser({id:"text",is:function(s){return true;},format:function(s){return $.trim(s.toLowerCase());},type:"text",sorting:"asc"});ts.addParser({id:"currency",is:function(s){return(/^[£$€?.]/.test(s))||s.substring(s.length-1).charCodeAt(0)==8364;},format:function(s,table){if(table.config.thousandSeparator!=''){s=s.replace(new RegExp((table.config.thousandSeparator=='.'?'\\.':table.config.thousandSeparator),"g"),"");}
if(table.config.decimal&&table.config.decimal!='.'){s=s.replace(new RegExp(table.config.decimal,"g"),".");}
return $.tablesorter.formatFloat(s.replace(new RegExp(/[^-+0-9.]/g),""));},type:"numeric",sorting:"desc"});ts.addParser({id:"ipaddress",is:function(s){return((/^\d{2,3}[\.]\d{2,3}[\.]\d{2,3}[\.]\d{2,3}$/.test(s))||(/^\d{1,3}[\.]\d{1,3}[\.]\d{1,3}$/.test(s)));},format:function(s){var a=s.split("."),r="",l=a.length;for(var i=0;i<l;i++){var item=a[i];if(item.length==2){r+="0"+item;}else{if(item.length==1){r+="00"+item;}else{r+=item;}}}
return $.tablesorter.formatFloat(r);},type:"numeric",sorting:"asc"});ts.addParser({id:"url",is:function(s){return(/^(https?|ftp|file):\/\/$/.test(s));},format:function(s){return jQuery.trim(s.replace(new RegExp(/(https?|ftp|file):\/\//),''));},type:"text",sorting:"asc"});ts.addParser({id:"rownum",is:function(s){return(/^\d+\.$/.test(s));},format:function(s){return $.tablesorter.formatFloat(s);},type:"numeric",sorting:"asc"});ts.addParser({id:"percent",is:function(s){return(/\%$/.test($.trim(s)));},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/%/g),""));},type:"numeric",sorting:"desc"});ts.addParser({id:"date",is:function(s,table){var mat=s.match(/^\d{2}[\/\.-]\d{2}[\/\.-]\d{4}?(| \d{2}:\d{2}(|:\d{2})( am| pm|))$/i)||s.match(/^\d{4}[\/\.-]\d{2}[\/\.-]\d{2}?(| \d{2}:\d{2}(|:\d{2})( am| pm|))$/i);return(mat!=null);},format:function(s,table){var fmt=table.config.dateFormat,date=s;dt="00000000";tm='';switch(fmt.substr(0,5)){case"Y-m-d":case"Y/m/d":case"Y.m.d":dt=date.substr(0,4)+'/'+date.substr(5,2)+'/'+date.substr(8,2);break;case"d-m-Y":case"d/m/Y":case"d.m.Y":dt=date.substr(6,4)+'/'+date.substr(3,2)+'/'+date.substr(0,2);break;case"m-d-Y":case"m/d/Y":case"m.d.Y":dt=date.substr(6,4)+'/'+date.substr(0,2)+'/'+date.substr(3,2);break;}
if(date.length==22|date.length==19){if(date.length==19){ampm=17;}else{ampm=20;}
if(date.substr(ampm,2).toUpperCase()=='PM'){if(date.substr(11,2)<'12'){hourspad='0'+(parseInt(date.substr(11,2),10)+12);}else{hourspad='0'+parseInt(date.substr(11,2),10);}}else{if(date.substr(11,2)=='12'){hourspad='00';}else{hourspad='0'+parseInt(date.substr(11,2),10);}}
hours=hourspad.substr(hourspad.length-2,2);if(date.length==22){dt+=' '+hours+':'+date.substr(14,2)+':'+date.substr(17,2);}else{dt+=' '+hours+':'+date.substr(14,2);}}else{if(date.length>10){dt+=' '+date.substr(11,2)+':'+date.substr(14,2)+':'+date.substr(17,2);}}
return $.tablesorter.formatFloat(new Date(dt).getTime());},type:"numeric",sorting:"desc"});ts.addParser({id:"time",is:function(s){var nt=(/^(([0-2]?[0-9]:[0-5][0-9](:[0-5][0-9]))|([0-9]?[0-9]:[0-5][0-9](:[0-5][0-9])\s(am|pm)))$/i.test(s));if(!nt){nt=(/^[0-9]+:[0-5][0-9](:[0-5][0-9])$/i.test(s));}
return nt;},format:function(s){var day=1,hours=0,days=0,fromdate;var nt=(/^(([0-2]?[0-9]:[0-5][0-9](:[0-5][0-9]))|([0-9]?[0-9]:[0-5][0-9](:[0-5][0-9])\s(am|pm)))$/i.test(s));if(!nt){hours=s.substring(0,s.indexOf(':'));if(hours>23){days=Math.floor(hours/24);hours=hours%24;}
fromdate=(1+days)+' '+hours+':'+s.substring(s.indexOf(':')+1);}else{fromdate='01 '+s;}
return $.tablesorter.formatFloat(new Date("2000/01/"+fromdate).getTime());},type:"numeric",sorting:"desc"});ts.addParser({id:"number",is:function(s,table){var c=table.config;return $.tablesorter.isDigit(s,c);},format:function(s,table){s=s.replace(new RegExp("[\<\>]","g"),"");if(table.config.thousandSeparator!=''){s=s.replace(new RegExp((table.config.thousandSeparator=='.'?'\\.':table.config.thousandSeparator),"g"),"");}
if(table.config.decimal&&table.config.decimal!='.'){s=s.replace(new RegExp(table.config.decimal,"g"),".");}
return $.tablesorter.formatFloat(s);},type:"numeric",sorting:"desc"});ts.addParser({id:"metadata",is:function(s){return false;},format:function(s,table,cell){var c=table.config,p=(!c.parserMetadataName)?'sortValue':c.parserMetadataName;return $(cell).metadata()[p];},type:"numeric",sorting:"desc"});ts.addWidget({id:"zebra",format:function(table){if(table.config.debug){var time=new Date();}
$(table).find('tbody tr:visible').filter(':even').removeClass(table.config.widgetZebra.css[1]).addClass(table.config.widgetZebra.css[0]).end().filter(':odd').removeClass(table.config.widgetZebra.css[0]).addClass(table.config.widgetZebra.css[1]);if(table.config.debug){$.tablesorter.benchmark("Applying Zebra widget",time);}}});})(jQuery);